# 帳票設計書 9-Extension Bisect Report

## 概要

本ドキュメントは、VS CodeのExtension Bisect機能における診断結果出力仕様を定義するものである。Extension Bisectは、問題を引き起こしている拡張機能を二分探索で特定する機能である。

### 本帳票の処理概要

Extension Bisectは、インストールされた拡張機能の中から問題を引き起こしている拡張機能を効率的に特定するための診断ツールである。

**業務上の目的・背景**：VS Codeに多数の拡張機能がインストールされている環境で問題が発生した際、どの拡張機能が原因かを特定することは困難である。Extension Bisectは二分探索アルゴリズムを使用して、最小限の再起動回数で問題の拡張機能を特定する。

**帳票の利用シーン**：
- 「Help: Start Extension Bisect」コマンドで開始
- 複数回のウィンドウ再起動と確認ダイアログを経て結果を特定
- 特定完了時に結果ダイアログとIssue Reporter連携

**主要な出力内容**：
1. 無効化された拡張機能数
2. 特定された問題拡張機能のID
3. 診断結果（問題あり/なし/特定不能）

**帳票の出力タイミング**：各Bisectステップでの通知と、最終的な特定完了時のダイアログ表示。

**帳票の利用者**：VS Codeユーザー、拡張機能開発者、サポートエンジニア

## 帳票種別

診断レポート / 通知

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Notification | - | 各Bisectステップでの通知 |
| - | Dialog | - | 最終結果ダイアログ |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| 出力形式 | 通知メッセージ / ダイアログ |
| 永続化 | StorageScope.APPLICATION |
| ストレージキー | extensionBisectState |
| 文字コード | UTF-8 |

### 状態データ形式

```json
{
  "extensions": ["ext.id1", "ext.id2", ...],
  "low": 0,
  "high": 10,
  "mid": 5
}
```

## 帳票レイアウト

### レイアウト概要

Bisect中は通知で進捗を表示し、完了時はダイアログで結果を表示する。

### 進捗通知

| No | 状態 | メッセージ | ボタン |
|----|------|----------|-------|
| 1 | 単数無効化 | "Extension Bisect is active and has disabled 1 extension." | "I can't reproduce" / "I can reproduce" / "Stop Bisect" |
| 2 | 複数無効化 | "Extension Bisect is active and has disabled {n} extensions." | 同上 |

### 結果ダイアログ

| No | 結果 | メッセージ | ボタン |
|----|------|----------|-------|
| 1 | 特定成功 | "Extension Bisect is done and has identified {id} as the extension causing the problem." | "Report Issue & Continue" / "Continue" |
| 2 | 特定失敗 | "Extension Bisect is done but no extension has been identified." | "OK" |

### 開始ダイアログ

| No | 項目 | 内容 |
|----|------|------|
| 1 | タイトル | "Extension Bisect" |
| 2 | 説明 | "Extension Bisect will use binary search to find an extension that causes a problem. During the process the window reloads repeatedly (~{n} times)." |
| 3 | ボタン | "Start Extension Bisect" |

## 出力条件

### 開始条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ユーザー拡張機能存在 | ExtensionType.Userの拡張機能がある | Yes |
| 有効な拡張機能 | extensionEnablementService.isEnabled | Yes |
| Bisect未実行 | isActive === false | Yes |

### 除外条件

以下の拡張機能はBisect対象外：

| 条件 | 説明 |
|------|------|
| Remote Resolver | リモート接続に必要な拡張機能 |
| --enable-extensions指定 | CLI引数で有効化された拡張機能 |

### 改ページ条件

N/A（通知/ダイアログ出力のため）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| StorageService (extensionBisectState) | Bisect状態保持 | StorageScope.APPLICATION |

### データ取得元

#### BisectState

| 参照項目 | 帳票項目との対応 | 取得方法 | 備考 |
|---------|----------------|---------|------|
| extensions | 対象拡張機能リスト | StorageService | string[] |
| low | 探索範囲下限 | StorageService | number |
| high | 探索範囲上限 | StorageService | number |
| mid | 探索中間点 | StorageService | number |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| mid | (low + high) / 2 | 切り捨て（\|0） | 二分探索中間点 |
| disabledCount | high - mid | - | 無効化された拡張機能数 |
| 推定再起動回数 | 2 + log2(extensions.length) | 切り捨て | 開始ダイアログ表示用 |

### 二分探索ロジック

| 条件 | 次の状態 |
|------|---------|
| seeingBad === true (再現する) | low = low, high = mid |
| seeingBad === false (再現しない) | low = mid, high = high |
| low === high - 1 | 探索完了、extensions[low]が問題 |
| mid === 0 && high === length && seeingBad | 全無効でも問題発生（VS Code自体の問題） |

## 処理フロー

### Bisect開始フロー

```mermaid
flowchart TD
    A[Start Extension Bisect] --> B[確認ダイアログ表示]
    B --> C{ユーザー確認}
    C -->|キャンセル| D[処理終了]
    C -->|開始| E[有効なユーザー拡張機能取得]
    E --> F[BisectState初期化]
    F --> G[状態をストレージに保存]
    G --> H[ウィンドウ再起動]
```

### Bisect進行フロー

```mermaid
flowchart TD
    A[ウィンドウ起動] --> B{Bisect状態あり?}
    B -->|No| C[通常起動]
    B -->|Yes| D[disabled拡張機能計算]
    D --> E[通知表示]
    E --> F{ユーザー選択}
    F -->|再現しない| G[seeingBad = false]
    F -->|再現する| H[seeingBad = true]
    F -->|Stop| I[reset & reload]
    G --> J[next呼び出し]
    H --> J
    J --> K{完了判定}
    K -->|継続| L[状態保存 & reload]
    K -->|完了| M[結果ダイアログ]
    M --> N{問題拡張特定?}
    N -->|Yes| O[Report Issue オプション]
    N -->|No| P[VS Code自体の問題]
    O --> Q{無効化維持?}
    Q -->|Yes| R[disableExtension]
    Q -->|No| S[何もしない]
    R --> T[reset & reload]
    S --> T
    P --> T
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 状態不正 | start()時にisActive=true | "invalid state" | reset後に再実行 |
| 状態不正 | next()時にisActive=false | "invalid state" | start()から再実行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 拡張機能: 0-200件程度 |
| 目標特定回数 | O(log n) 回の再起動 |
| 同時実行数上限 | 1セッション |

## セキュリティ考慮事項

- Bisect状態はローカルストレージに保持
- 拡張機能IDのみ保存（機密情報なし）
- Issue Reporter連携時は通常のIssue Reporterフローを使用

## 備考

- Bisect中はctxIsBisectActiveコンテキストがtrueに設定
- Remote Resolver拡張機能はBisect対象外（リモート接続維持のため）
- 結果ダイアログで「Keep this extension disabled」チェックボックスあり

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Bisect状態のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | BisectState class (行44-65) |
| 1-2 | extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | IExtensionBisectService interface (行32-42) |

**読解のコツ**: BisectStateがストレージに保存される状態、low/mid/highが二分探索の範囲。

#### Step 2: サービス実装を理解する

Bisectサービスの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | ExtensionBisectService (行67-162) |

**主要処理フロー**:
- **行76-91**: コンストラクタで状態復元とdisabledマップ構築
- **行102-117**: isDisabledByBisect()で無効化判定
- **行123-131**: start()でBisect開始
- **行133-156**: next()で次ステップへ進行
- **行158-161**: reset()で状態クリア

#### Step 3: UI実装を理解する

通知とダイアログの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | ExtensionBisectUi (行168-210) |
| 3-2 | extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | StartBisect Action (行217-254) |
| 3-3 | extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | ContinueBisect Action (行256-350) |

**主要処理フロー**:
- **行184-208**: _showBisectPrompt()で進捗通知
- **行234-253**: StartBisect.run()で開始処理
- **行267-322**: ContinueBisect.run()で継続処理

### プログラム呼び出し階層図

```
Help: Start Extension Bisect
    │
    └─ StartBisect Action.run()
           │
           ├─ dialogService.confirm()
           │
           ├─ extensionManagement.getInstalled()
           │
           ├─ extensionsBisect.start()
           │      │
           │      └─ storageService.store()
           │
           └─ hostService.reload()

ウィンドウ起動 (Bisect中)
    │
    └─ ExtensionBisectUi (constructor)
           │
           ├─ ctxIsBisectActive.set(true)
           │
           └─ _showBisectPrompt()
                  │
                  └─ notificationService.prompt()
                         │
                         ├─ "I can't reproduce" → next(false)
                         ├─ "I can reproduce" → next(true)
                         └─ "Stop Bisect" → reset()

ContinueBisect Action.run()
    │
    ├─ bisectService.next(seeingBad)
    │      │
    │      └─ 状態更新 or 完了判定
    │
    └─ [完了時] dialogService.confirm()
           │
           ├─ "Report Issue" → openIssueReporter
           └─ extensionEnablementService.disableExtension()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

User拡張機能リスト    ┌─────────────────────┐
                     │                     │
  ─────────────────▶│ ExtensionBisect    │
                     │   Service          │
ユーザー選択         │                     │──────▶ 進捗通知
 (再現する/しない)  │ - start()          │        (disabledCount)
  ─────────────────▶│ - next()           │
                     │ - isDisabledBy     │──────▶ 結果ダイアログ
                     │   Bisect()         │        (特定拡張機能ID)
                     │                     │
                     └─────────────────────┘
                            │
                            ▼
                     StorageService
                     (extensionBisectState)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extensionBisect.ts | `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` | ソース | Bisectサービスとアクション |
| extensionManagement.ts | `src/vs/workbench/services/extensionManagement/common/extensionManagement.ts` | ソース | 拡張機能管理インターフェース |
| host.ts | `src/vs/workbench/services/host/browser/host.ts` | ソース | ウィンドウ再起動 |
| storage.ts | `src/vs/platform/storage/common/storage.ts` | ソース | ストレージサービス |
